#include <windows.h>
#include <stdio.h>


FILE *fp;


UINT8 buf[0x800000];
INT32 bufSize;



// MIDI channel remap - 16-bit
INT16 patch1Scan[] =
{
	0x8B, 0xDF,

	0x4B,
	0x2E, 0x80, 0xBF, 0x100, 0x100, 0xFF,
	0x75, 0xF7,

	0x8B, 0xFB,
	0x2E, 0x8A, 0x84, 0x101, 0x101,
	0x2E, 0x88, 0x85, 0x102, 0x102,

	0x8A, 0xD8,
	0x24, 0x0F,
	0x81, 0xE3, 0xF0, 0x00,
	0xD1, 0xEB,
	0xD1, 0xEB
};


INT16 patch1Raw[] =
{
	0x4F,
	0x83, 0xFF, 0x09,
	0x74, 0xFA,

	0x2E, 0x80, 0xBD, 0x100, 0x100, 0xFF,
	0x75, 0xF2,

	0x2E, 0x8A, 0x84, 0x101, 0x101,
	0x2E, 0x88, 0x85, 0x102, 0x102,

	0x8A, 0xD8,
	0x24, 0x0F,
	0x81, 0xE3, 0xF0, 0x00,
	0xC1, 0xEB, 0x02,
};



// MIDI channel remap - 32-bit
INT16 patch2Scan[] =
{
	0x66, 0x8B, 0xDF,
	0x81, 0xE3, 0xFF, 0xFF, 0x00, 0x00,

	0x66, 0x4B,
	0x80, 0xBB, 0x200, 0x200, 0x200, 0x200, 0xFF,
	0x75, 0xF5,

	0x66, 0x8B, 0xFB,
	0x8A, 0x86, 0x201, 0x201, 0x201, 0x201,
	0x88, 0x87, 0x202, 0x202, 0x202, 0x202,

	0x8A, 0xD8,
	0x24, 0x0F,
	0x81, 0xE3, 0xF0, 0x00, 0x00, 0x00,
	0x66, 0xD1, 0xEB,
	0x66, 0xD1, 0xEB,
};


INT16 patch2Raw[] =
{
	0x90, 0x90, 0x90,

	0x66, 0x4F,
	0x66, 0x83, 0xFF, 0x09,
	0x74, 0xF8,

	0x80, 0xBF, 0x200, 0x200, 0x200, 0x200, 0xFF,
	0x75, 0xEF,

	0x90, 0x90, 0x90,
	0x8A, 0x86, 0x201, 0x201, 0x201, 0x201,
	0x88, 0x87, 0x202, 0x202, 0x202, 0x202,

	0x8A, 0xD8,
	0x24, 0x0F,
	0x81, 0xE3, 0xF0, 0x00, 0x00, 0x00,
	0x66, 0xC1, 0xEB, 0x02,
	0x90, 0x90
};



// NewRisingSun
// - enable digital for MT-32, General MIDI devices

INT16 patchKrondorScan[] =
{
	0x83, 0x3E, -1, -1, 0x04,
	0x75, 0x0A,

	0x68, -1, -1,
	0x66, 0x6A, 0x00,
	0x6A, 0x02,
	0xEB, 0x0D,

	0x68, -1, -1,
	0x66, 0x68, 0xFE, 0xFF, 0x00, 0x00,
};


INT16 patchKrondorRaw[] = 
{
	0x83, 0x3E, -1, -1, 0x04,
	0x75, 0x0A,

	0x68, -1, -1,
	0x66, 0x6A, 0x00,
	0x6A, 0x02,
	0xEB, 0x0D,

	0x68, -1, -1,
	0x66, 0x68, 0x00, 0x00, 0x00, 0x00,
};



INT Patch( INT type, INT addr, INT scanSize, INT patchSize, INT16 patchScan[], INT16 patchRaw[] )
{
	INT16 ptr[256];
	INT16 ptr32[256];


	scanSize /= sizeof( INT16 );
	patchSize /= sizeof( INT16 );



	for( INT lcv = 0; lcv < scanSize; lcv++ )
	{
		// wildcard - skip byte
		if( patchScan[ lcv ] == (INT16) -1 )
			continue;


		// wildcard - ptr 16-bit
		if( patchScan[ lcv ] >= (INT16) 0x100 &&
				patchScan[ lcv ] < (INT16) 0x200 )
		{
			ptr[ patchScan[lcv] - 0x100 ] = *( (INT16 *) ( buf + addr + lcv ) );
			lcv++;

			continue;
		}


		// wildcard - ptr 16-bit
		if( patchScan[ lcv ] >= (INT16) 0x200 &&
				patchScan[ lcv ] < (INT16) 0x300 )
		{
			ptr32[ patchScan[lcv] - 0x200 ] = *( (INT32 *) ( buf + addr + lcv ) );
			lcv += 3;

			continue;
		}


		if( (UINT8) patchScan[ lcv ] != buf[ addr + lcv ] )
			break;
	}


	// not found
	if( lcv != scanSize )
		return 0;


	// #################################################
	// #################################################
	// #################################################

	for( lcv = 0; lcv < patchSize; lcv++ )
	{
		// wildcard - skip byte
		if( patchRaw[ lcv ] == (INT16) -1 )
			continue;


		// wildcard - ptr
		if( patchRaw[ lcv ] >= (INT16) 0x100 &&
				patchRaw[ lcv ] < (INT16) 0x200 )
		{
			*( (INT16 *) ( buf + addr + lcv ) ) = ptr[ patchRaw[lcv] - 0x100 ];
			lcv++;

			continue;
		}


		// wildcard - ptr32
		if( patchRaw[ lcv ] >= (INT16) 0x200 &&
				patchRaw[ lcv ] < (INT16) 0x300 )
		{
			*( (INT32 *) ( buf + addr + lcv ) ) = ptr32[ patchRaw[lcv] - 0x200 ];
			lcv += 3;

			continue;
		}


		buf[ addr + lcv ] = (UINT8) patchRaw[ lcv ];
	}


	return 1;
}



INT CALLBACK WinMain( HINSTANCE, HINSTANCE, LPSTR, INT )
{
	BOOL found;
	BOOL krondor;


	found = FALSE;
	krondor = FALSE;


	fp = fopen( "SIERRA.EXE", "rb+" );
	if( fp ) found = TRUE;


	if( !fp )
	{
		fp = fopen( "TIM.EXE", "rb+" );
		if( fp ) found = TRUE;
	}


	if( !fp )
	{
		fp = fopen( "TIM2.EXE", "rb+" );
		if( fp ) found = TRUE;
	}


	if( !fp )
	{
		fp = fopen( "KRONDOR.EXE", "rb+" );
		if( fp )
		{
			found = TRUE;
			krondor = TRUE;
		}
	}


	if( !fp )
	{
		fp = fopen( "TURBOSCI.EXE", "rb+" );
		if( fp ) found = TRUE;
	}



	if( !fp )
	{
		MessageBox( NULL, "No game found", "Sierra / Dynamix", MB_OK );
		return 0;
	}


	// ##################################################
	// ##################################################
	// ##################################################

	// file size
	fseek( fp, 0, SEEK_END );
	bufSize = ftell(fp);


	fseek( fp, 0, SEEK_SET );
	fread( buf, 1, bufSize, fp );



	// scan for pattern
	for( INT lcv = 0; lcv < bufSize; lcv++ )
	{
		if( Patch( 1, lcv, sizeof(patch1Scan), sizeof(patch1Raw), patch1Scan, patch1Raw ) )
			MessageBox( 0, "Patch - MIDI channel remap", "Game patch", MB_OK );


		if( Patch( 1, lcv, sizeof(patch2Scan), sizeof(patch2Raw), patch2Scan, patch2Raw ) )
			MessageBox( 0, "Patch - MIDI channel remap", "Game patch", MB_OK );


		if( krondor )
		{
			if( Patch( 1, lcv, sizeof(patchKrondorScan), sizeof(patchKrondorRaw), patchKrondorScan, patchKrondorRaw ) )
				MessageBox( 0, "Patch - digital sound", "Game patch", MB_OK );
		}
	}


	// ##################################################
	// ##################################################
	// ##################################################

	// set to write mode
	fseek( fp, 0, SEEK_SET );


	fwrite( buf, 1, bufSize, fp );
	fclose( fp );


	return 0;
}
